/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.circuit.server;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.ComponentHarvestContext;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.math.Vec2i;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.scm.circuit.CircuitAdjacency;
import com.technicalitiesmc.scm.circuit.TileAccessor;
import com.technicalitiesmc.scm.circuit.TilePointer;
import com.technicalitiesmc.scm.circuit.server.Circuit;
import com.technicalitiesmc.scm.circuit.server.CircuitTile;
import com.technicalitiesmc.scm.circuit.server.ComponentInstance;
import com.technicalitiesmc.scm.circuit.util.ComponentSlotPos;
import com.technicalitiesmc.scm.circuit.util.TilePos;
import com.technicalitiesmc.scm.circuit.util.TileSection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ServerTileAccessor
implements TileAccessor {
    private final CircuitTile tile;
    private boolean removed;

    public ServerTileAccessor(CircuitTile tile) {
        this.tile = tile;
    }

    CircuitTile getTile() {
        return this.tile;
    }

    @Override
    public boolean isAreaEmpty() {
        return this.tile.getCircuit().isTileAreaEmpty(this.tile.getPosition());
    }

    @Override
    public void clearArea() {
        this.tile.getCircuit().clearTileArea(this.tile.getPosition(), null);
    }

    @Override
    public void visitAreaShapes(Consumer<VoxelShape> consumer) {
        TilePos origin = this.tile.getPosition();
        Circuit circuit = this.tile.getCircuit();
        for (TileSection section : TileSection.VALUES) {
            CircuitTile t = circuit.getTile(origin.offsetNeg(section));
            if (t == null) continue;
            t.stream(section).map(ComponentInstance::getShape).map(section::offsetNeg).forEach(consumer);
        }
    }

    public void releaseClaim() {
        this.tile.getCircuit().releaseClaim(this.tile.getPosition());
    }

    public void clearAndRemove(ComponentHarvestContext context) {
        if (this.removed) {
            return;
        }
        this.removed = true;
        this.tile.getCircuit().clearAreaAndRemoveTile(this.tile, context);
    }

    public void scheduleTick(Level level) {
        this.tile.getCircuit().scheduleTick(level);
    }

    @Nullable
    public ComponentInstance get(Vec3i pos, ComponentSlot slot) {
        return this.tile.getCircuit().get(this.tile.getPosition().pack(pos), slot);
    }

    @Nullable
    public Supplier<ComponentInstance> tryPutLater(Vec3i pos, ComponentType type, ComponentType.Factory factory) {
        return this.tile.getCircuit().tryPutLater(this.tile.getPosition().pack(pos), type, factory);
    }

    @Nullable
    public ComponentInstance tryPut(Vec3i pos, ComponentType type, ComponentType.Factory factory) {
        return this.tile.getCircuit().tryPut(this.tile.getPosition().pack(pos), type, factory);
    }

    public InteractionResult use(Vec3i pos, ComponentSlot slot, Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        return this.tile.getCircuit().use(this.tile.getPosition().pack(pos), slot, player, hand, sideHit, hit);
    }

    public void tryHarvest(Vec3i pos, ComponentSlot slot, ComponentHarvestContext context) {
        this.tile.getCircuit().harvest(this.tile.getPosition().pack(pos), slot, context);
    }

    public void onInputsUpdated(VecDirectionFlags sides) {
        this.tile.notifyRedstoneUpdate(sides);
    }

    public CompoundTag describe(CompoundTag tag) {
        tag = this.tile.describe(tag);
        CircuitAdjacency[] adjacency = this.tile.getCircuit().calculateAdjacencyMap(this.tile.getPosition());
        int[] adjIndex = new int[adjacency.length];
        for (int i = 0; i < adjacency.length; ++i) {
            adjIndex[i] = adjacency[i].ordinal();
        }
        tag.m_128385_("adjacency", adjIndex);
        return tag;
    }

    public static interface Host {
        public ServerTileAccessor getAccessor();

        @Nullable
        public Host find(Vec2i var1);

        public void updatePointer(TilePointer var1);

        public void syncState(Map<ComponentSlotPos, ComponentState> var1, CircuitAdjacency[] var2);

        public void drop(ItemStack var1);

        public void playSound(SoundEvent var1, SoundSource var2, float var3, float var4);

        public int getInput(VecDirection var1);

        public void setOutput(VecDirection var1, int var2);
    }
}

